
<?php
require_once __DIR__ . '/config.php';

function h($s) { return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }

function random_string($len=12) {
  $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
  $out = '';
  for ($i=0;$i<$len;$i++) $out .= $chars[random_int(0, strlen($chars)-1)];
  return $out;
}

function move_uploaded_to_baseurl($fileField) {
  if (!isset($_FILES[$fileField]) || $_FILES[$fileField]['error'] !== UPLOAD_ERR_OK) {
    return [false, 'Tidak ada file yang diupload atau terjadi error.'];
  }
  $tmp = $_FILES[$fileField]['tmp_name'];
  $orig = $_FILES[$fileField]['name'];
  $ext = strtolower(pathinfo($orig, PATHINFO_EXTENSION));
  $safeName = preg_replace('/[^a-zA-Z0-9-_\.]/','_', pathinfo($orig, PATHINFO_FILENAME));
  if ($safeName === '') $safeName = 'file';
  $newName = $safeName . '_' . random_string(8) . ($ext ? '.' . $ext : '');

  if (!is_dir(UPLOAD_DIR)) {
    @mkdir(UPLOAD_DIR, 0775, true);
  }
  $dest = UPLOAD_DIR . '/' . $newName;
  if (!move_uploaded_file($tmp, $dest)) {
    return [false, 'Gagal memindahkan file. Pastikan folder upload writeable.'];
  }
  // Simpan sebagai FULL URL berbasis BASE_URL
  $fileUrl = UPLOAD_URL . '/' . $newName;
  return [true, $fileUrl];
}
