
<?php
require_once __DIR__ . '/../auth.php';
require_login();

$ok = isset($_GET['ok']) ? 'Data berhasil disimpan.' : '';
$q = trim($_GET['q'] ?? '');
if ($q) {
  $st = db()->prepare("SELECT * FROM surat_masuk WHERE Nomor_Surat LIKE ? OR Asal_surat LIKE ? OR perihal LIKE ? ORDER BY No_Agenda DESC");
  $wild = "%$q%";
  $st->execute([$wild,$wild,$wild]);
  $rows = $st->fetchAll();
} else {
  $rows = db()->query("SELECT * FROM surat_masuk ORDER BY No_Agenda DESC LIMIT 200")->fetchAll();
}
?>
<?php include __DIR__ . '/partials_header.php'; ?>

<div class="flex items-center justify-between mb-4">
  <h2 class="text-xl font-semibold text-slate-800">Surat Masuk</h2>
  <a href="<?= BASE_URL ?>/surat_masuk_add.php" class="px-3 py-2 rounded-lg bg-indigo-600 text-white">Tambah</a>
</div>

<?php if ($ok): ?><div class="mb-4 text-sm text-green-700 bg-green-50 border border-green-200 rounded-lg p-3"><?= htmlspecialchars($ok) ?></div><?php endif; ?>

<form method="get" class="mb-4">
  <input name="q" value="<?= h($q) ?>" placeholder="Cari nomor surat / asal / perihal..." class="border rounded-lg px-3 py-2 w-full md:w-1/2">
</form>

<div class="bg-white rounded-2xl shadow overflow-x-auto">
  <table class="min-w-full text-sm">
    <thead class="bg-slate-100 text-slate-700">
      <tr>
        <th class="text-left p-3">No</th>
        <th class="text-left p-3">Nomor Surat</th>
        <th class="text-left p-3">Tanggal</th>
        <th class="text-left p-3">Asal</th>
        <th class="text-left p-3">Perihal</th>
        <th class="text-left p-3">File</th>
      </tr>
    </thead>
    <tbody class="divide-y">
      <?php foreach ($rows as $r): ?>
        <tr>
          <td class="p-3"><?= (int)$r['No_Agenda'] ?></td>
          <td class="p-3"><?= h($r['Nomor_Surat']) ?></td>
          <td class="p-3"><?= h($r['Tanggal_surat']) ?></td>
          <td class="p-3"><?= h($r['Asal_surat']) ?></td>
          <td class="p-3"><?= h($r['perihal']) ?></td>
          <td class="p-3"><a href="<?= h($r['file_surat']) ?>" class="text-indigo-600 hover:underline" target="_blank">Buka</a></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php include __DIR__ . '/partials_footer.php'; ?>
