
<?php
require_once __DIR__ . '/../auth.php';
require_login();

// Ambil angka ringkas
$cm = db()->query("SELECT COUNT(*) AS c FROM surat_masuk")->fetch()['c'] ?? 0;
$ck = db()->query("SELECT COUNT(*) AS c FROM surat_keluar")->fetch()['c'] ?? 0;

// 6 terbaru
$masuk = db()->query("SELECT No_Agenda, Nomor_Surat, Tanggal_surat, Asal_surat, file_surat FROM surat_masuk ORDER BY No_Agenda DESC LIMIT 6")->fetchAll();
$keluar = db()->query("SELECT No_Agenda, Nomor_surat, tanggal_surat, Tujuan_surat, file_surat FROM surat_keluar ORDER BY No_Agenda DESC LIMIT 6")->fetchAll();
?>
<?php include __DIR__ . '/partials_header.php'; ?>

<h2 class="text-xl font-semibold text-slate-800 mb-4">Dashboard</h2>

<div class="grid md:grid-cols-2 gap-4 mb-6">
  <div class="bg-white rounded-2xl shadow p-6">
    <div class="text-sm text-slate-500">Surat Masuk</div>
    <div class="text-3xl font-bold mt-2"><?= (int)$cm ?></div>
    <div class="mt-4 flex gap-3">
      <a href="<?= BASE_URL ?>/surat_masuk_add.php" class="px-3 py-1 rounded-lg border hover:bg-slate-50 text-sm">Tambah</a>
      <a href="<?= BASE_URL ?>/surat_masuk_list.php" class="px-3 py-1 rounded-lg border hover:bg-slate-50 text-sm">Lihat semua</a>
    </div>
  </div>
  <div class="bg-white rounded-2xl shadow p-6">
    <div class="text-sm text-slate-500">Surat Keluar</div>
    <div class="text-3xl font-bold mt-2"><?= (int)$ck ?></div>
    <div class="mt-4 flex gap-3">
      <a href="<?= BASE_URL ?>/surat_keluar_add.php" class="px-3 py-1 rounded-lg border hover:bg-slate-50 text-sm">Tambah</a>
      <a href="<?= BASE_URL ?>/surat_keluar_list.php" class="px-3 py-1 rounded-lg border hover:bg-slate-50 text-sm">Lihat semua</a>
    </div>
  </div>
</div>

<div class="grid md:grid-cols-2 gap-6">
  <div class="bg-white rounded-2xl shadow overflow-hidden">
    <div class="p-4 border-b font-medium">Terbaru: Surat Masuk</div>
    <div class="divide-y">
      <?php foreach ($masuk as $m): ?>
        <div class="p-4 text-sm flex items-center justify-between gap-4">
          <div>
            <div class="font-medium"><?= h($m['Nomor_Surat']) ?></div>
            <div class="text-slate-500"><?= h($m['Asal_surat']) ?> • <?= h($m['Tanggal_surat']) ?></div>
          </div>
          <a href="<?= h($m['file_surat']) ?>" target="_blank" class="text-indigo-600 hover:underline">File</a>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
  <div class="bg-white rounded-2xl shadow overflow-hidden">
    <div class="p-4 border-b font-medium">Terbaru: Surat Keluar</div>
    <div class="divide-y">
      <?php foreach ($keluar as $k): ?>
        <div class="p-4 text-sm flex items-center justify-between gap-4">
          <div>
            <div class="font-medium"><?= h($k['Nomor_surat']) ?></div>
            <div class="text-slate-500"><?= h($k['Tujuan_surat']) ?> • <?= h($k['tanggal_surat']) ?></div>
          </div>
          <a href="<?= h($k['file_surat']) ?>" target="_blank" class="text-indigo-600 hover:underline">File</a>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>

<?php include __DIR__ . '/partials_footer.php'; ?>
