
<?php
require_once __DIR__ . '/db.php';
session_start();

function current_user() {
  return $_SESSION['user'] ?? null;
}

function require_login() {
  if (!current_user()) {
    header('Location: ' . BASE_URL . '/login.php');
    exit;
  }
}

function login($username, $password) {
  $st = db()->prepare("SELECT * FROM `user` WHERE username = ? LIMIT 1");
  $st->execute([$username]);
  $user = $st->fetch();
  if ($user && !empty($user['password']) && password_verify($password, $user['password'])) {
    $_SESSION['user'] = [
      'id' => (int)$user['id_user'],
      'nama' => $user['nama'],
      'username' => $user['username'],
      'role_id' => (int)$user['user_role_id'],
    ];
    return true;
  }
  return false;
}

function logout() {
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params['path'], $params['domain'], $params['secure'], $params['httponly']
    );
  }
  session_destroy();
}
